﻿/*
# Apprendre à programmer en ActionScript
# A. Tasso
# Chapitre 10 : Le traitement de données multimédias
# Projet   : Portfolio Multimédia
# Fichier : ProjetChapitre10.fla
# Classe : Item.as, Menu.as, Vignette.as, BarreNavigation.as, controleurSimple.as et Infos.as
*/

// Définition de la classe Infos
class Infos extends MovieClip {

  private var unFormat:TextFormat;
  private var unTexte:TextField ;
  private var infosTexte:LoadVars;

  public function Infos(cible:MovieClip,leFichier:String, nx:Number, ny:Number) { 

   var cetteInfo:Infos = this;
   // Créer un format de texte, Arial 16 blanc
   unFormat = new TextFormat();
   unFormat.font = "Arial";
   unFormat.size=16;
   unFormat.align="left";
   unFormat.color=0xFFFFFF;

   // créer une zone de texte
   cible.createTextField("unTexte", _global.niveauText+1 ,nx, ny, 300, 180);
   cetteInfo.unTexte = cible["unTexte"];
   cetteInfo.unTexte.setNewTextFormat(unFormat);
   cetteInfo.unTexte.selectable = false;
   cetteInfo.unTexte.wordWrap = true;
   cetteInfo.unTexte.multiline = true;
   cetteInfo.unTexte.background = false;
   cetteInfo.unTexte.border = false;
   cetteInfo.unTexte.type = "dynamic";
   
   // Charger le fichier passer en paramètre du constructeur
   cetteInfo.infosTexte = new LoadVars();
   cetteInfo.infosTexte.load(leFichier);
   
   // Afficher le texte dans la zone de texte
   cetteInfo.infosTexte.onData = function(texteLu:String):Void {
      if (texteLu != undefined) {
         cetteInfo.unTexte.text = texteLu;
      } else {
      trace("Impossible de charger :"+leFichier );
      }
    }; 
  }
}

